unit LangManReg;

//***************************************************************************
//**  LangMan - Localization components for Delphi (Support UNICODE)       **
//***************************************************************************
//**                                                                       **
//**  File:      LangManReg.pas                                            **
//**                                                                       **
//**  Version:   1.2.2                                                     **
//**                                                                       **
//**  Date:      14.8.2012                                                 **
//**                                                                       **
//**  Author:    Ing. Tomas Halabala - REGULACE.ORG                        **
//**                                                                       **
//**  License:   This components set is free for personal use.             **
//**             Comercial use is not allowed without author permission!   **
//**                                                                       **
//**             Tato sada komponent je zdarma pro nekomern pouit.     **
//**             Komern vyuit konzultujte s autorem!                   **
//**                                                                       **
//**             en je dovoleno pouze v nezmnn podob.              **
//**             Autor neodpovd za dn ppadn kody zpsoben        **
//**             pouvnm tto komponenty.                               **
//**                                                                       **
//**             Tento zdrojov kd je chrnn autorskm zkonem.          **
//**                                                                       **
//**  Disclaimer:THE SOFTWARE AND ANY RELATED DOCUMENTATION IS PROVIDED    **
//**             "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR   **
//**             IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       **
//**             WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR   **
//**             PURPOSE, OR NONINFRINGEMENT. AUTHOR DOES NOT WARRANT,     **
//**             GUARANTEE, OR MAKE ANY REPRESENTATIONS REGARDING THE USE, **
//**             OR THE RESULTS OF THE USE, OF THE SOFTWARE IN TERMS OF    **
//**             CORRECTNESS, ACCURACY, RELIABILITY, OR OTHERWISE.         **
//**             THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE         **
//**             OF THE SOFTWARE REMAINS WITH YOU.                         **
//**                                                                       **
//**  Copyright: Copyright  2009-2012 by Ing.Tomas Halabala.              **
//**                                                                       **
//**  E-mail:    tomas.halabala@regulace.org                               **
//**                                                                       **
//**  Webpages:  http://www.regulace.org                                   **
//**                                                                       **
//***************************************************************************

interface

uses Classes, Designintf, DesignEditors;

type
  TDefaultLanguageProperty = class (TStringProperty)
    function GetAttributes: TPropertyAttributes; override;
    procedure GetValues(Proc: TGetStrProc); override;
  end;

  TNameProperty = class (TComponentNameProperty)
    procedure SetValue(const Value: string); override;
  end;

procedure Register;

implementation

uses Forms, Dialogs, ToolsAPI, SysUtils,
     LangManComp, LangManSys, LangManCtrls, LangManDlg;

//***************************************************************************
//**  LangMan Component Property editor                                    **
//***************************************************************************

function TDefaultLanguageProperty.GetAttributes: TPropertyAttributes;
begin
{$IF CompilerVersion > 19}
  Result := [paValueList, paValueEditable];
{$ELSE}
  Result := [paValueList];
{$IFEND}
end;

procedure TDefaultLanguageProperty.GetValues(Proc: TGetStrProc);
var LNGI: Word;
    DT_Languages: TStringList;
    DT_Project: IOTAProject;
    DT_LangDir: String;
    SearchRec: TSearchRec;
    LangName: string;
    FindResult: Integer;
begin
  DT_Languages := TStringList.Create;
  DT_Languages.Add(DT_EngineOptions.DesignLang);
  DT_Project := GetActiveProject;
  if DT_Project.FileName <> '' then begin
    DT_LangDir := GetLangDir(ExtractFilePath(DT_Project.FileName), DT_EngineOptions.Subdir);
    FindResult := FindFirst(DT_LangDir + '*.*',faAnyFile,SearchRec);
    while FindResult = 0 do begin
      if ExtractFileExt(LowerCase(SearchRec.Name)) = LowerCase(DT_EngineOptions.LangFileExt) then begin
        LangName := GetLangName(DT_LangDir + SearchRec.Name, '[' + DT_EngineOptions.LangFileSign + ']', false);
        if LangName <> '' then DT_Languages.Add(LangName);
      end;
      FindResult := FindNext(SearchRec);
    end;
    FindClose(SearchRec);
  end;
  for LNGI := 0 to DT_Languages.Count - 1 do Proc(DT_Languages.Strings[LNGI]);
  DT_Languages.Free;
end;

procedure TNameProperty.SetValue(const Value: string);
var Component, ClientOwner: TComponent;
    LMEngine: TLangManEngine;
    DT_Project: IOTAProject;
    OldName, OwnerName: String;
    CI: Integer;
begin
  Component := Designer.GetComponent(GetValue);        // This Component renaming
  ClientOwner := Component;                            // Owner Form or Top owner
  if (NOT (ClientOwner is TCustomForm)) and
     (NOT (ClientOwner is TCustomFrame)) and
     (NOT (ClientOwner is TDataModule)) and
     (ClientOwner.Owner <> nil) and
     (ClientOwner.Owner <> Application) then ClientOwner := ClientOwner.Owner;
  OldName := GetValue;                                 // Store old name of Component
  OwnerName := ClientOwner.Name;                       // Store old owner name
  if (ClientOwner <> Component) and (ClientOwner.Name = Value) then begin
    MessageDlg('Component name must be other than owner name!',mtError,[mbOK],0);
    Exit;
  end;
  try
    inherited SetValue(Value);                         // Set New component Name
    if ClientOwner.ComponentCount > 0 then begin       // Find LangManClients and rename component in laguage files
      for CI := 0 to ClientOwner.ComponentCount - 1 do begin
        if ClientOwner.Components[CI].ClassType = TLangManClient then begin
          LMEngine := (ClientOwner.Components[CI] as TLangManClient).LangManEngine;
          if LMEngine <> nil then begin
            DT_Project := GetActiveProject;
            if DT_Project.FileName <> '' then RenameComponent(

               GetLangDir(ExtractFilePath(DT_Project.FileName), LMEngine.LangSubdirectory),
               LMEngine.LangFileExtension,
               '[' + LMEngine.LangFileSignature + ']',
               OwnerName,
               OldName,
               Value
                                                             );
          end;
        end;
      end;
    end;
  finally

  end;
end;

//***************************************************************************
//**  LangMan Components Register function                                 **
//***************************************************************************

procedure Register;
begin
  RegisterComponents('Language Manager', [TLangManEngine, TLangManClient,
                                          TDesignedLexicon, TProgrammableLexicon,
                                          TLangCombo, TLangFlagsCombo, TValuedLabel,
                                          TLangManRichEdit]);
  RegisterPropertyEditor(TypeInfo(TLanguage),TLangManEngine,'DefaultLanguage',TDefaultLanguageProperty);
  RegisterPropertyEditor(TypeInfo(TStrings),TLexicon,'',TLexiconStringsProperty);
  RegisterPropertyEditor(TypeInfo(TComponentName),TComponent,'Name',TNameProperty);

  // REM next line to disable alternative TStrings editor
  RegisterPropertyEditor(TypeInfo(TStrings),nil,'',TStringsProperty);
end;

end.
