unit LangManCtrls;

//***************************************************************************
//**  LangMan - Localization components for Delphi (Support UNICODE)       **
//***************************************************************************
//**                                                                       **
//**  File:      LangManCtrls.pas                                          **
//**                                                                       **
//**  Version:   1.2.0                                                     **
//**                                                                       **
//**  Date:      18.1.2012                                                 **
//**                                                                       **
//**  Author:    Ing. Tomas Halabala - REGULACE.ORG                        **
//**                                                                       **
//**  License:   This components set is free for personal use.            **
//**             Comercial use is not allowed without author permission!   **
//**                                                                       **
//**             Tato sada komponent je zdarma pro nekomern pouit.     **
//**             Komern vyuit konzultujte s autorem!                   **
//**                                                                       **
//**             en je dovoleno pouze v nezmnn podob.              **
//**             Autor neodpovd za dn ppadn kody zpsoben        **
//**             pouvnm tto komponenty.                               **
//**                                                                       **
//**             Tento zdrojov kd je chrnn autorskm zkonem.          **
//**                                                                       **
//**  Disclaimer:THE SOFTWARE AND ANY RELATED DOCUMENTATION IS PROVIDED    **
//**             "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR   **
//**             IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       **
//**             WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR   **
//**             PURPOSE, OR NONINFRINGEMENT. AUTHOR DOES NOT WARRANT,     **
//**             GUARANTEE, OR MAKE ANY REPRESENTATIONS REGARDING THE USE, **
//**             OR THE RESULTS OF THE USE, OF THE SOFTWARE IN TERMS OF    **
//**             CORRECTNESS, ACCURACY, RELIABILITY, OR OTHERWISE.         **
//**             THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE         **
//**             OF THE SOFTWARE REMAINS WITH YOU.                         **
//**                                                                       **
//**  Copyright: Copyright  2009-2012 by Ing.Tomas Halabala.              **
//**                                                                       **
//**  E-mail:    tomas.halabala@regulace.org                               **
//**                                                                       **
//**  Webpages:  http://www.regulace.org                                   **
//**                                                                       **
//***************************************************************************

interface

uses Classes, Controls, StdCtrls;

type
  TValuedLabel = class (TCustomLabel)
  private
    Space           : string;
    fValue          : TCaption;
    fValueName      : TCaption;
    fValueSeparator : string;
    fValueSpaces    : Byte;
  protected
    procedure SetCaption; virtual;
    procedure SetValue(Value: TCaption); virtual;
    procedure SetValueName(Name: TCaption); virtual;
    procedure SetValueSeparator(Separator: string); virtual;
    procedure SetValueSpaces(Spaces: byte); virtual;
  published
    property Align;
    property Alignment;
    property Anchors;
    property AutoSize;
    property BiDiMode;
    property Color nodefault;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
{$IF CompilerVersion > 19}
    property EllipsisPosition;
    property GlowSize; // Windows Vista only
{$IFEND}
    property Enabled;
    property FocusControl;
    property Font;
    property ParentBiDiMode;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Layout;
    property Value: TCaption read fValue write SetValue;
    property ValueName: TCaption read fValueName write SetValueName;
    property ValueSeparator : string read fValueSeparator write SetValueSeparator;
    property ValueSpaces : byte read fValueSpaces write SetValueSpaces;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
{$IF CompilerVersion > 19}
    property OnMouseActivate;
{$IFEND}
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnMouseEnter;
    property OnMouseLeave;
    property OnStartDock;
    property OnStartDrag;
  end;

implementation

procedure TValuedLabel.SetCaption;
begin
  Caption := fValueName + fValueSeparator + Space + fValue;
end;

procedure TValuedLabel.SetValue(Value: TCaption);
begin
  fValue := Value;
  SetCaption;
end;

procedure TValuedLabel.SetValueName(Name: TCaption);
begin
  fValueName := Name;
  SetCaption;
end;

procedure TValuedLabel.SetValueSeparator(Separator: string);
begin
  fValueSeparator := Separator;
  SetCaption;
end;

procedure TValuedLabel.SetValueSpaces(Spaces: Byte);
var I: byte;
begin
  fValueSpaces := Spaces;
  Space := '';
  if fValueSpaces > 0 then for I := 1 to fValueSpaces do Space := Space + ' ';
  SetCaption;
end;

end.
