unit LangManCompatibility;

//***************************************************************************
//**  LangMan - Localization components for Delphi (Support UNICODE)       **
//***************************************************************************
//**                                                                       **
//**  File:      LangManCompatibility.pas                                  **
//**                                                                       **
//**  Version:   1.2.0                                                     **
//**                                                                       **
//**  Date:      18.1.2012                                                 **
//**                                                                       **
//**  Author:    Ing. Tomas Halabala - REGULACE.ORG                        **
//**                                                                       **
//**  License:   This components set is free for personal use.             **
//**             Comercial use is not allowed without author permission!   **
//**                                                                       **
//**             Tato sada komponent je zdarma pro nekomern pouit.     **
//**             Komern vyuit konzultujte s autorem!                   **
//**                                                                       **
//**             en je dovoleno pouze v nezmnn podob.              **
//**             Autor neodpovd za dn ppadn kody zpsoben        **
//**             pouvnm tto komponenty.                               **
//**                                                                       **
//**             Tento zdrojov kd je chrnn autorskm zkonem.          **
//**                                                                       **
//**  Disclaimer:THE SOFTWARE AND ANY RELATED DOCUMENTATION IS PROVIDED    **
//**             "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR   **
//**             IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       **
//**             WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR   **
//**             PURPOSE, OR NONINFRINGEMENT. AUTHOR DOES NOT WARRANT,     **
//**             GUARANTEE, OR MAKE ANY REPRESENTATIONS REGARDING THE USE, **
//**             OR THE RESULTS OF THE USE, OF THE SOFTWARE IN TERMS OF    **
//**             CORRECTNESS, ACCURACY, RELIABILITY, OR OTHERWISE.         **
//**             THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE         **
//**             OF THE SOFTWARE REMAINS WITH YOU.                         **
//**                                                                       **
//**  Copyright: Copyright  2009-2012 by Ing.Tomas Halabala.              **
//**                                                                       **
//**  E-mail:    tomas.halabala@regulace.org                               **
//**                                                                       **
//**  Webpages:  http://www.regulace.org                                   **
//**                                                                       **
//***************************************************************************

interface

uses Classes;

const DEFAULT_CHARSET = 1;

type
  TCollectionItem = record
    Caption: String;
    DisplayName, FileMask: string;   // TCustomFileDialog
    CommandLinkHint: String;         // TCustomTaskDialog
  end;

  TTaskDialogButtonItem = TCollectionItem;

  TCollectionItems = record
    Items: array of TCollectionItem;
    Count: Integer;
  end;

  TFileTypeItems = TCollectionItems;
  TTaskDialogButtons = TCollectionItems;

  TUniversal = class(TComponent)
  private
    StrTemp: string;
  public
    property Caption: String read StrTemp write StrTemp;
    property Text: String read StrTemp write StrTemp;
    property Title: String read StrTemp write StrTemp;
  end;

  TCustomFileDialog = class(TUniversal)
  private
    StrTemp: string;
    FTTemp: TFileTypeItems;
  public
    property FileNameLabel: String read StrTemp write StrTemp;
    property OKButtonLabel: String read StrTemp write StrTemp;
    property FileTypes: TFileTypeItems read FTTemp write FTTemp;
  end;

  TCustomTaskDialog = class(TUniversal)
  private
    StrTemp: String;
    BtnsTemp: TTaskDialogButtons;
  public
    property Buttons: TTaskDialogButtons read BtnsTemp write BtnsTemp;
    property ExpandButtonCaption: String read StrTemp write StrTemp;
    property ExpandedText: String read StrTemp write StrTemp;
    property FooterText: String read StrTemp write StrTemp;
    property RadioButton: TTaskDialogButtons read BtnsTemp write BtnsTemp;
    property VerificationText: String read StrTemp write StrTemp;
  end;

implementation

end.
