﻿unit LangForm;

//***************************************************************************
//**  LangMan - Localization components for Delphi (Support UNICODE)       **
//***************************************************************************
//**                                                                       **
//**  File:      LangForm.pas                                              **
//**                                                                       **
//**  Version:   1.2.0                                                     **
//**                                                                       **
//**  Date:      18.1.2012                                                 **
//**                                                                       **
//**  Author:    Ing. Tomas Halabala - REGULACE.ORG                        **
//**                                                                       **
//**  License:   This components set is free for personal use.             **
//**             Comercial use is not allowed without author permission!   **
//**                                                                       **
//**             Tato sada komponent je zdarma pro nekomerční použití.     **
//**             Komerční využití konzultujte s autorem!                   **
//**                                                                       **
//**             Šíření je dovoleno pouze v nezměněné podobě.              **
//**             Autor neodpovídá za žádné případné škody způsobené        **
//**             používáním této komponenty.                               **
//**                                                                       **
//**             Tento zdrojový kód je chráněn autorským zákonem.          **
//**                                                                       **
//**  Disclaimer:THE SOFTWARE AND ANY RELATED DOCUMENTATION IS PROVIDED    **
//**             "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR   **
//**             IMPLIED, INCLUDING, WITHOUT LIMITATION, THE IMPLIED       **
//**             WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR   **
//**             PURPOSE, OR NONINFRINGEMENT. AUTHOR DOES NOT WARRANT,     **
//**             GUARANTEE, OR MAKE ANY REPRESENTATIONS REGARDING THE USE, **
//**             OR THE RESULTS OF THE USE, OF THE SOFTWARE IN TERMS OF    **
//**             CORRECTNESS, ACCURACY, RELIABILITY, OR OTHERWISE.         **
//**             THE ENTIRE RISK ARISING OUT OF USE OR PERFORMANCE         **
//**             OF THE SOFTWARE REMAINS WITH YOU.                         **
//**                                                                       **
//**  Copyright: Copyright © 2009-2012 by Ing.Tomas Halabala.              **
//**                                                                       **
//**  E-mail:    tomas.halabala@regulace.org                               **
//**                                                                       **
//**  Webpages:  http://www.regulace.org                                   **
//**                                                                       **
//***************************************************************************

interface

uses LangManCompatibility,
     Windows, Messages, SysUtils, Classes, Controls, Forms, Dialogs, StdCtrls,
     ExtCtrls, Buttons, Grids, ValEdit, Contnrs, Graphics, ImgList, ExtDlgs,
     LangManSys;

type
  TLanguageManager = class(TForm)
    LangFilesPanel: TPanel;
    CopyPanel: TPanel;
    Image: TImage;
    LLanguage: TLabel;
    LangCombo: TComboBox;
    AddLangButton: TSpeedButton;
    SaveDialog: TSaveDialog;
    LangListEditor: TValueListEditor;
    FinishBtn: TBitBtn;
    BotPanel: TPanel;
    RightBtnPanel: TPanel;
    GroupCombo: TComboBox;
    LGroup: TLabel;
    ILeft: TImage;
    IRight: TImage;
    ObjectCombo: TComboBox;
    LItem: TLabel;
    LObject: TLabel;
    TopPanel: TPanel;
    LRefLangLabel: TLabel;
    LRefTextLabel: TLabel;
    LRefText: TLabel;
    LRefLang: TLabel;
    BtnPanel: TPanel;
    DontTransBtn: TSpeedButton;
    Panel1: TPanel;
    SplitPanel: TPanel;
    Splitter: TSplitter;
    FlagImage: TImage;
    OpenPictureDialog: TOpenPictureDialog;
    MenuIcons: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure LangListEditorSelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure FinishBtnClick(Sender: TObject);
    procedure ILeftMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure IRightMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure ObjectComboChange(Sender: TObject);
    procedure DontTransBtnClick(Sender: TObject);
    procedure LangListEditorDrawCell(Sender: TObject; ACol, ARow: Integer;
      Rect: TRect; State: TGridDrawState);
    procedure LangListEditorStringsChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure SplitterMoved(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure LangListEditorKeyPress(Sender: TObject; var Key: Char);
    procedure FlagImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure LangListEditorKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    WorkIndexes        : TWordList;
    SourceIndexes      : TWordList;
    DrawRow            : Integer;
    SelectedRow        : Integer;
    DrawRect           : TRect;
    LangModify         : Boolean;
    procedure DrawSig(AOwner: TObject);
    procedure PrepareDraw(Row: Integer; Rect: TRect);
  public
    WorkStruct         : TComponentStructure;
    SourceStruct       : TComponentStructure;
    WorkLexicon        : TIndexedItems;
    SourceLexicon      : TLexiconData;
    ClientGroups       : TComponentList;
    SuperiorLanguage   : TLanguage;
    EditMode           : Boolean;
    LexiconMode        : Boolean;
    LangManLangVisible : Boolean;
    CurrentGroup       : Integer;
    CurrentObject      : Integer;
    NotFoundMessage    : String;
    CloseQueryMessage  : String;
    EraseFlagMessage   : String;
    LangLabelBuf       : String;
    LangMessageBuf     : String;
    procedure EditStart;
    procedure ParseStruct;
    function IsUntranslated: Boolean;
    procedure TranslateObject;
    procedure StoreCurrentTranslate(NoTransObject: boolean);
    procedure LItemAktualize;
  end;

  TValueListEditorFree = class(TValueListEditor)
  public
    property EditList;
  end;

implementation

{$R *.dfm}

var Col0Width: Real;

procedure TLanguageManager.DrawSig(AOwner: TObject);
var ChgableBuf: Word;
    ItemBuf: string;

  procedure DrawSig(Color: TColor);
  begin
    DrawRow := -1;
    LangListEditor.Canvas.Brush.Color := Color;
    LangListEditor.Canvas.FillRect(DrawRect);
  end;

begin
  if DrawRow > 0 then begin
    try
      if LexiconMode then begin
        if (WorkIndexes.Count > 0) then begin
          ItemBuf := SourceLexicon.ReadItem(GroupCombo.Text,WorkIndexes.GetWord(DrawRow-1));
          if LangListEditor.Cells[1,DrawRow] <> ItemBuf then begin
            if ItemBuf <> '' then DrawSig(CL_CHANGED)
                             else DrawSig(CL_OLDITEM);
          end else DrawSig(CL_NEW);
        end;
      end else begin
        if (WorkStruct.Names.Count > 0) and (SourceIndexes.Count > 0) then begin
          ChgableBuf := WorkStruct.Changeable.GetWord(WorkIndexes.GetWord(DrawRow-1));
          if (ca_OLD = (ChgableBuf and ca_OLD)) then begin
            if (LangListEditor.Cells[1,DrawRow] <> WorkStruct.Text.Strings[WorkIndexes.GetWord(DrawRow-1)]) then begin
              WorkStruct.Changeable.RewriteWord(WorkIndexes.GetWord(DrawRow-1),ChgableBuf and (NOT ca_OLD));
            end else begin
              DrawSig(CL_OLDTRANS);
              DrawRow := -1;
              Exit;
            end;
          end;
          if (LangListEditor.Cells[1,DrawRow] <> SourceStruct.Text.Strings[SourceIndexes.GetWord(DrawRow-1)])
            then DrawSig(CL_CHANGED)
            else DrawSig(CL_NEW);
        end;
      end;
    finally
      DrawRow := -1;
    end;
  end;
end;

procedure TLanguageManager.PrepareDraw(Row: Integer; Rect: TRect);
begin
  DrawRect.BottomRight := Point(Rect.Right - SGN_MARGIN,Rect.Bottom - SGN_MARGIN);
  DrawRect.TopLeft := Point(Rect.Right - SGN_MARGIN - SGN_WIDTH,Rect.Top + SGN_MARGIN);
  DrawRow := Row;
end;

procedure TLanguageManager.DontTransBtnClick(Sender: TObject);
var OldOI: Integer;
begin
  OldOI := ObjectCombo.ItemIndex;
  StoreCurrentTranslate(true);
  ParseStruct;
  if (ObjectCombo.Items.Count > OldOI) then ObjectCombo.ItemIndex := OldOI
                                       else ObjectCombo.ItemIndex := ObjectCombo.Items.Count - 1;
  if ObjectCombo.ItemIndex >= 0 then ObjectCombo.OnChange(Self)
                                else GroupCombo.OnChange(Self);
end;

procedure TLanguageManager.EditStart;
begin
  AddLangButton.Visible := false;
  LangFilesPanel.Enabled := true;
  FinishBtn.Visible := true;
  LangListEditor.Enabled := true;
  LRefLang.Caption := SuperiorLanguage;
  if GroupCombo.Items.Count > 0 then GroupCombo.ItemIndex := 0;
  GroupCombo.OnChange(Self);
  LangListEditor.Canvas.OnChanging := DrawSig;
  try
    if LoadedFlag then FlagImage.Picture.Graphic.LoadFromStream(GetFlag)
                  else MenuIcons.GetBitmap(2, FlagImage.Picture.Bitmap);
  finally
    FlagImage.Visible := true;
  end;
end;

procedure TLanguageManager.ParseStruct;
var OI: Integer;
begin
  ObjectCombo.Clear;
  if WorkStruct.Names.Count > 0 then begin
    for OI := 0 to WorkStruct.Names.Count - 1 do begin
      if ((WorkStruct.Changeable.GetWord(OI) and ca_YES) = ca_YES) and
         (ObjectCombo.Items.IndexOf(WorkStruct.Names.Strings[OI]) < 0)
         then ObjectCombo.Items.Add(WorkStruct.Names.Strings[OI]);
    end;
  end;
  DontTransBtn.Enabled := ObjectCombo.Items.Count > 0;
end;

function TLanguageManager.IsUntranslated: Boolean;
var II: Integer;
begin
  Result := false;
  if LexiconMode then begin
    for II := 0 to WorkLexicon.MaxIndex do begin
      if WorkLexicon.IsIncluded(II) and (WorkLexicon.Get(II) = SourceLexicon.ReadItem(GroupCombo.Text,II)) then begin
        Result := true;
        Exit;
      end;
    end;
  end else begin
    if WorkStruct.Names.Count > 0 then begin
      if (ObjectCombo.Text <> '') and (ObjectCombo.ItemIndex >= 0) then begin
        for II := 0 to WorkStruct.Names.Count - 1 do begin
          if (WorkStruct.Names.Strings[II] = ObjectCombo.Text) and
             ((WorkStruct.Changeable.GetWord(II) and ca_YES) = ca_YES) then begin

            if (ca_OLd = (WorkStruct.Changeable.GetWord(II) and ca_OLD)) or
               (WorkStruct.Text.Strings[II] = GetStructItem(SourceStruct,
                                                            WorkStruct.Names.Strings[II],
                                                            WorkStruct.Parents.Strings[II],
                                                            WorkStruct.Properties.GetWord(II),
                                                            WorkStruct.ItemAddr.Strings[II])) then begin
              Result := true;
              Exit;
            end;
          end;
        end;
      end;
    end;
  end;
end;

procedure TLanguageManager.TranslateObject;
var II: Integer;
    Err: Boolean;
begin
  StoreCurrentTranslate(false);
  CurrentGroup := GroupCombo.ItemIndex;
  CurrentObject := ObjectCombo.ItemIndex;
  WorkIndexes.Clear;
  SourceIndexes.Clear;
  LRefText.Caption := '';
  LangListEditor.Strings.Clear;
  if LexiconMode then begin
 //   if WorkLexicon.MaxIndex >= 0 then
      for II := 0 to WorkLexicon.MaxIndex do begin
        if WorkLexicon.IsIncluded(II) then begin
          LangListEditor.InsertRow('Item[' + IntToStr(II) + ']',WorkLexicon.Get(II),true);
          WorkIndexes.AddWord(II);
        end;
      end;
  end else begin
    if WorkStruct.Names.Count > 0 then begin
      if (ObjectCombo.Text <> '') and (ObjectCombo.ItemIndex >= 0) then begin
        for II := 0 to WorkStruct.Names.Count - 1 do begin
          if (WorkStruct.Names.Strings[II] = ObjectCombo.Text) and
             ((WorkStruct.Changeable.GetWord(II) and ca_YES) = ca_YES) then begin

            LangListEditor.InsertRow(GetPropertyName(@WorkStruct,II),
                                     WorkStruct.Text.Strings[II], true);
            WorkIndexes.AddWord(II);
            SourceIndexes.AddWord(GetStructIndex(SourceStruct,
                                                 WorkStruct.Names.Strings[II],
                                                 WorkStruct.Parents.Strings[II],
                                                 WorkStruct.Properties.GetWord(II),
                                                 WorkStruct.ItemAddr.Strings[II]));
          end;
        end;
      end;
    end;
  end;
//  LangListEditor.InsertRow('','',true);
  LangListEditor.SetFocus;
  LangListEditor.OnSelectCell(Self,2,1,Err);
end;

procedure TLanguageManager.SplitterMoved(Sender: TObject);
begin
  LangListEditor.DefaultColWidth := SplitPanel.Width;
end;

procedure TLanguageManager.StoreCurrentTranslate(NoTransObject: boolean);
var II,WI: Integer;
begin
  if LexiconMode then begin
    if (WorkIndexes.Count > 0) and (CurrentGroup >= 0) then begin
      for II := 0 to WorkIndexes.Count - 1 do begin
        if (LangListEditor.Cells[1,II+1] <> SourceLexicon.ReadItem(GroupCombo.Items.Strings[CurrentGroup],WorkIndexes.GetWord(II))) or
           (LangListEditor.Cells[1,II+1] <> WorkLexicon.Get(WorkIndexes.GetWord(II)))
          then WorkLexicon.Write(WorkIndexes.GetWord(II),LangListEditor.Cells[1,II+1])
          else WorkLexicon.Write(WorkIndexes.GetWord(II),'');
      end;
    end;
  end else begin
    if (WorkStruct.Names.Count > 0) and (CurrentObject >= 0) and (SourceIndexes.Count > 0) then begin
      II := 0;
      for WI := 0 to WorkStruct.Names.Count - 1 do begin
        if (WorkStruct.Names.Strings[WI] = ObjectCombo.Items.Strings[CurrentObject]) and
           ((WorkStruct.Changeable.GetWord(WI) and ca_YES) = ca_YES) then begin
          if NoTransObject then begin
            WorkStruct.Changeable.RewriteWord(WI,ca_CHANGED);
          end else if ((LangListEditor.Cells[1,II+1] <> SourceStruct.Text.Strings[SourceIndexes.GetWord(II)]) or
                      (LangListEditor.Cells[1,II+1] <> WorkStruct.Text.Strings[WI])) and
                      ((WorkStruct.Changeable.GetWord(WI) and ca_OLD) = 0)
            then begin
              WorkStruct.Text.Strings[WI] := LangListEditor.Cells[1,II+1];
              WorkStruct.Changeable.RewriteWord(WI,ca_CHANGED OR ca_YES);
            end;
          Inc(II);
        end;
      end;
      CurrentObject := -1; // ulozeny zmeny ve WorkStructure
    end;
  end;
end;

procedure TLanguageManager.LItemAktualize;
begin
  if (ObjectCombo.Items.Count > 0) and (ObjectCombo.ItemIndex >= 0) then begin
    LItem.Caption := IntToStr(ObjectCombo.ItemIndex + 1) + ' / ' +
                       IntToStr(ObjectCombo.Items.Count);
  end else LItem.Caption := '-/-';
  ObjectCombo.Hint := ObjectCombo.Text;
end;

procedure SortStructure(Structure: TComponentStructure);
var I, II: Integer;
    Data : TStructLine;
begin
  if Structure.Names.Count > 0 then begin
   for I := 1 to Structure.Names.Count - 1 do begin
    if (Structure.Names.Strings[I] <> Structure.Names.Strings[I-1]) or
       (Structure.Parents.Strings[I] <> Structure.Parents.Strings[I-1]) then begin
      II := I+1;
      while (II < Structure.Names.Count) and
            ((Structure.Names.Strings[I] <> Structure.Names.Strings[II]) or
             (Structure.Parents.Strings[I] <> Structure.Parents.Strings[II])) do Inc(II);
      if II < Structure.Names.Count then begin
        with Data do begin
          Name := Structure.Names.Strings[II];
          Parent := Structure.Parents.Strings[II];
          Text := Structure.Text.Strings[II];
          Properties := Structure.Properties.GetWord(II);
          ItemAddr := Structure.ItemAddr.Strings[II];
          Changeable := Structure.Changeable.GetWord(II);
          Structure.Names.Strings[II] := Structure.Names.Strings[I];
          Structure.Parents.Strings[II] := Structure.Parents.Strings[I];
          Structure.Text.Strings[II] := Structure.Text.Strings[I];
          Structure.Properties.Strings[II] := Structure.Properties.Strings[I];
          Structure.ItemAddr.Strings[II] := Structure.ItemAddr.Strings[I];
          Structure.Changeable.Strings[II] := Structure.Changeable.Strings[I];
          Structure.Names.Strings[I] := Name;
          Structure.Parents.Strings[I] := Parent;
          Structure.Text.Strings[I] := Text;
          Structure.Properties.RewriteWord(I,Properties);
          Structure.ItemAddr.Strings[I] := ItemAddr;
          Structure.Changeable.RewriteWord(I, Changeable);
        end;
      end;
    end;
   end;
  end;
end;

procedure TLanguageManager.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := (NOT LangModify) or (MessageDlg(CloseQueryMessage,mtConfirmation,[mbYES,mbNO],0) = mrYES);
end;

procedure TLanguageManager.FormCreate(Sender: TObject);
begin
  Color := $009A5A12; //$8E4E0A;
  DrawRow := -1;
  WorkIndexes := TWordList.Create;
  SourceIndexes := TWordList.Create;
  WorkStruct := TComponentStructure.Create;
  SourceStruct := TComponentStructure.Create;
  SourceLexicon := TLexiconData.Create;
  WorkLexicon := TIndexedItems.Create('Temp lexicon');
  ClientGroups := TComponentList.Create;
  Col0Width := LangListEditor.DefaultColWidth / LangListEditor.Width;
end;

procedure TLanguageManager.FormDestroy(Sender: TObject);
begin
  WorkIndexes.Free;
  SourceIndexes.Free;
  WorkStruct.Free;
  SourceStruct.Free;
  SourceLexicon.Free;
  WorkLexicon.Free;
  ClientGroups.Free;
end;

procedure TLanguageManager.FormResize(Sender: TObject);
begin
//  LangListEditor.DefaultColWidth := Round(Col0Width * LangListEditor.Width);
end;

procedure TLanguageManager.FormShow(Sender: TObject);
begin
  LangModify := false;
  if Scaled AND (PixelsPerInch <> 96) then begin
    LangListEditor.DefaultRowHeight := Round(PixelsPerInch * LangListEditor.DefaultRowHeight / 96);
  end;
  SplitPanel.Width := LangListEditor.DefaultColWidth;
  if EditMode and (LangCombo.Items.Count = 1) then begin
    LangCombo.ItemIndex := 0;
    LangCombo.OnChange(Self);
  end;
end;

procedure TLanguageManager.ILeftMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Eofject, FindUntranslated: Boolean;
begin
  Eofject := false;
  FindUntranslated := ssShift in Shift;
  repeat
    if (ObjectCombo.Enabled) and (ObjectCombo.ItemIndex > 0) then begin
      ObjectCombo.ItemIndex := ObjectCombo.ItemIndex - 1;
      if NOT FindUntranslated then ObjectCombo.OnChange(Self);
    end else if (GroupCombo.ItemIndex > 0) then begin
      GroupCombo.ItemIndex := GroupCombo.ItemIndex - 1;
      GroupCombo.OnChange(Self);
      if ObjectCombo.Enabled then begin
        ObjectCombo.ItemIndex := ObjectCombo.Items.Count - 1;
        if NOT FindUntranslated then ObjectCombo.OnChange(Self);
      end;
    end else Eofject := true;
  until (NOT FindUntranslated) or Eofject or IsUntranslated;
  if FindUntranslated then begin
    if Eofject then MessageDlg(NotFoundMessage,mtInformation,[mbOK],0);
    if ObjectCombo.Enabled then ObjectCombo.OnChange(Self);
  end;
end;

procedure TLanguageManager.IRightMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var Eofject, FindUntranslated: Boolean;
begin
  Eofject := false;
  FindUntranslated := ssShift in Shift;
  repeat
    if (ObjectCombo.Items.Count > 0) and (ObjectCombo.Enabled) and
       (ObjectCombo.ItemIndex < (ObjectCombo.Items.Count - 1)) then begin

      ObjectCombo.ItemIndex := ObjectCombo.ItemIndex + 1;
      if NOT FindUntranslated then ObjectCombo.OnChange(Self);
    end else if (GroupCombo.Items.Count > 0) and
                (GroupCombo.ItemIndex < (GroupCombo.Items.Count - 1)) then begin

      GroupCombo.ItemIndex := GroupCombo.ItemIndex + 1;
      GroupCombo.OnChange(Self);
    end else Eofject := true;
  until (NOT FindUntranslated) or Eofject or IsUntranslated;
  if FindUntranslated then begin
    if Eofject then MessageDlg(NotFoundMessage, mtInformation, [mbOK], 0);
    if (ObjectCombo.Items.Count > 0) and (ObjectCombo.Enabled) and (NOT LexiconMode)
      then ObjectCombo.OnChange(Self);
  end;
end;

procedure TLanguageManager.LangListEditorDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
  if (ARow > 0) and (ARow < LangListEditor.RowCount) and (ACol = 0) then begin
    PrepareDraw(ARow,Rect);
  end else DrawRow := -1;
end;

procedure TLanguageManager.LangListEditorKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_RIGHT then SendMessage(TValueListEditorFree(LangListEditor).EditList.Handle, EM_SETSEL, -1, -1);
end;

procedure TLanguageManager.LangListEditorKeyPress(Sender: TObject; var Key: Char);
begin
  LangModify := true;
end;

procedure TLanguageManager.LangListEditorSelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  if (ARow > 0) and (ARow < (WorkIndexes.Count + 1)) then begin
    if LexiconMode then LRefText.Caption := SourceLexicon.ReadItem(GroupCombo.Text,WorkIndexes.GetWord(ARow-1))
                   else LRefText.Caption := SourceStruct.Text.Strings[SourceIndexes.GetWord(ARow-1)];
    SelectedRow := ARow;
  end else SelectedRow := 0;
end;

procedure TLanguageManager.LangListEditorStringsChange(Sender: TObject);
begin
  if (SelectedRow > 0) then begin
    PrepareDraw(SelectedRow,LangListEditor.CellRect(0,SelectedRow));
    DrawSig(Sender);
  end;
end;

procedure TLanguageManager.ObjectComboChange(Sender: TObject);
begin
  LItemAktualize;
  if ObjectCombo.Items.Count > 0 then TranslateObject;
end;

procedure TLanguageManager.FinishBtnClick(Sender: TObject);
begin
  LangModify := false;
  ModalResult := mrOK;
end;

procedure TLanguageManager.FlagImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if ssLeft in Shift then begin
    if OpenPictureDialog.Execute then begin
      FlagImage.Picture.LoadFromFile(OpenPictureDialog.FileName);
      AdaptFlagImage(FlagImage.Picture);
      RenderFlag(FlagImage.Picture);
      LangModify := true;
    end;
  end else begin
    if MessageDlg(EraseFlagMessage, mtConfirmation, [mbYES,mbNO], 0) = mrYES then begin
    {$IF CompilerVersion > 19}
      FlagImage.Picture.Bitmap.SetSize(0,0);
    {$ELSE}
      FlagImage.Picture.Bitmap.Height := 0;
      FlagImage.Picture.Bitmap.Width := 0;
    {$IFEND}
      Repaint;
      MenuIcons.GetBitmap(2, FlagImage.Picture.Bitmap);
      EraseFlag;
      LangModify := true;
      FlagImage.Invalidate;
    end;
  end;
end;

end.
